{*
* Pts Prestashop Theme Framework for Prestashop 1.6.x
*
* @package   pspagebuilder
* @version   5.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}
{if isset($contents)}
<div class="widget-images block {$addition_cls|escape:'html':'UTF-8'} {if isset($stylecls)&&$stylecls}block-{$stylecls|escape:'html':'UTF-8'}{/if}">
	{if isset($widget_heading)&&!empty($widget_heading)}
	<h4 class="title_block space-20">
		{$widget_heading|escape:'html':'UTF-8'}
	</h4>
	{/if}

	<div class="widget-inner block_content clearfix">
		<div class="widget-content boxcarousel owl-carousel-play" data-ride="owlcarousel">
		 	{if count($contents) > 1}
			 	<div class="carousel-controls">
				 	<a class="carousel-control carousel-sm left left_carousel" href="#"><span class="icon-prev"></span></a>
					<a class="carousel-control carousel-sm right right_carousel" href="#"><span class="icon-next"></span></a>
				</div>
			{/if}
			<div class="owl-carousel" data-columns="1" data-pagination="false" data-navigation="true"
				data-desktop="[1200,1]"
				data-desktopsmall="[992,1]"
				data-tablet="[768,1]"
				data-mobile="[480,1]">
				{foreach from=$contents item=content name=content_name}
					{if $content.image}
						<div class="item">
							<div class="contentsliderbox nopadding">
								<div class="col-sm-3 col-md-4">
									<div class="hidden-xs contentslider-image">
										{if $content.image}
											<img class="img-responsive" src="{$content.image|escape:'html':'UTF-8'}" alt="" />
										{/if}
									</div>
								</div>
								<div class="col-sm-9 col-md-8">
									<div class="contentslider-content">
										{if $content.title}
											<h3 class="contentslider-title">{$content.title|escape:'html':'UTF-8'}</h3>
										{/if}
										{if $content.description}
											<div class="contentslider-desc">{$content.description}{* HTML, cannot escape *}</div>
										{/if}
										{if $content.button_link}
											<a class="btn btn-default btn-lg fancybox-media" href="{$content.button_link}" title="{l s='See it in action' mod='pspagebuilder'}">
												<i class="icon icon-play-circle-o"></i>{l s='See it in action' mod='pspagebuilder'}
											</a>
										{/if}
									</div>
								</div>
							</div>
						</div>
					{/if}
				{/foreach}
			</div>
		</div>
	</div>
</div>
{/if} 
<script type="text/javascript">
jQuery(document).ready(function() {

	$(".fancybox-media").click(function() {
		$.fancybox({
			'padding'		: 0,
			'autoScale'		: false,
			'transitionIn'	: 'none',
			'transitionOut'	: 'none',
			'title'			: this.title,
			'width'			: 640,
			'height'		: 385,
			'href'			: this.href.replace(new RegExp("watch\\?v=", "i"), 'v/'),
			'type'			: 'swf',
			'swf'			: {
			'wmode'				: 'transparent',
			'allowfullscreen'	: 'true'
			}
		});

		return false;
	});
});
</script>