<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

class PsWidgetRotateimages extends PsWidgetPageBuilder {

	protected $max_image_size = 1048576;
	public $name = 'rotateimages';
	public $group = 'image';

	public function beforeAdminProcess($controller)
	{
		if (!Tools::getValue('widgetaction'))
			$controller->addJS(__PS_BASE_URI__.'modules/pspagebuilder/views/js/admin/image_gallery.js');
	}

	public static function getWidgetInfo()
	{
		return array('label' => ('Rotate Images'), 'explain' => 'Create Rotate Images From Folder', 'group' => 'image');
	}

	public function renderForm($data)
	{
		$key = time();

		$helper = $this->getFormHelper();
		$soption = array(
			array(
				'id' => 'active_on',
				'value' => 1,
				'label' => $this->l('Enabled')
			),
			array(
				'id' => 'active_off',
				'value' => 0,
				'label' => $this->l('Disabled')
			)
		);

		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Images'),
					'name' => 'imageslist',
					'class' => 'imageupload',
					'default' => '',
					'id' => 'imageslist'.$key,
					'desc' => 'Put image folder in the image folder ROOT_SHOP_DIR/img/'
				),
				array(
					'type' => 'text',
					'label' => $this->l('Image size'),
					'name' => 'size',
					'class' => 'image',
					'default' => '',
					'id' => 'imagesize'.$key,
					'desc' => 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. 
						Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use \'thumbnail\' size.'
				)
			),
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);

		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		$string = '
				<script type="text/javascript">
						$(".imageupload").WPO_Gallery({gallery:true});
				</script>
			';
		return '<div id="imageslist'.$key.'">'.$helper->generateForm($this->fields_form).$string.'</div>';
	}

	public function renderContent($setting)
	{
		$t = array(
			'name' => '',
			'imageslist' => '',
			'size' => '',
			'images' => array(),
			'id' => time()
		);

		$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? 'https://' : 'http://';
		$url = Tools::htmlentitiesutf8($protocol.$_SERVER['HTTP_HOST'].__PS_BASE_URI__);

		$setting = array_merge($t, $setting);
		$size = explode('x', $setting['size']);

		$tmp = explode(',', $setting['imageslist']);
		$output = array();

		foreach ($tmp as $key => $file)
		{
			$output[] = _PAGEBUILDER_IMAGE_URL_.$file;
		}
		$images_str = '';
		if ($output) {
			$images_str = '"'.implode('","', $output).'"';
		}
		$setting['images'] = $images_str;
		
		$output = array('type' => 'rotateimages', 'data' => $setting);
		return $output;
	}

	protected function renderImage($url, $image, $size)
	{
		$setting = array();

		$setting['thumbnailurl'] = _PAGEBUILDER_IMAGE_URL_.$image;
		$setting['imageurl'] = _PAGEBUILDER_IMAGE_URL_.$image;
		if (count($size) == 2)
		{
			$cache = _PS_CACHE_DIR_.'pspagebuilder/';
			if (!file_exists($cache.$image))
			{
				if (!is_dir($cache))
					mkdir($cache, 0755);
				if (ImageManager::resize(_PAGEBUILDER_IMAGE_DIR_.$image, $cache.$image, $size[0], $size[1]))
					$setting['thumbnailurl'] = $url.'cache/pspagebuilder/'.$image;
			}
			else
				$setting['thumbnailurl'] = $url.'cache/pspagebuilder/'.$image;

		}
		return $setting;
	}

}
