<?php
/**
 * Pts Prestashop Theme Framework for Prestashop 1.6.x
 *
 * @package   pspagebuilder
 * @version   5.0
 * @author    http://www.prestabrain.com
 * @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
 *               <info@prestabrain.com>.All rights reserved.
 * @license   GNU General Public License version 2
 */

class PsWidgetContentslider extends PsWidgetPageBuilder {

	public $name = 'contentslider';
	public $group = 'product';

	public static function getWidgetInfo()
	{
		return array('label' => ('Content Slider'), 'explain' => 'Content Slider', 'group' => 'prestashop');
	}

	public function renderForm($data)
	{
		$key = time();
		$helper = $this->getFormHelper();
		$inputs = array();
		for ($i = 1; $i <= 5; $i++) {
			$inputs[] = array(
				'type' => 'text',
				'label' => $this->l('Image ').$i,
				'name' => 'imagefile'.$i,
				'class' => 'imageupload',
				'default' => '',
				'id' => 'imagefile'.$i.$key
			);
			$inputs[] = array(
				'type' => 'text',
				'label' => $this->l('Title ').$i,
				'name' => 'title'.$i,
				'default' => '',
				'lang' => true
			);
			$inputs[] = array(
				'type' => 'textarea',
				'label' => $this->l('Description ').$i,
				'name' => 'description'.$i,
				'default' => '',
				'lang' => true
			);
			$inputs[] = array(
				'type' => 'text',
				'label' => $this->l('Button Link ').$i,
				'name' => 'button_link'.$i,
				'default' => '',
				'lang' => true
			);
		}
		$this->fields_form[1]['form'] = array(
			'legend' => array(
				'title' => $this->l('Widget Form.'),
			),
			'input' => $inputs,
			'submit' => array(
				'title' => $this->l('Save'),
				'class' => 'button'
			)
		);
		$default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($data),
			'languages' => Context::getContext()->controller->getLanguages(),
			'id_language' => $default_lang
		);

		$string = '
				<script type="text/javascript">
						$(".imageupload").WPO_Gallery({gallery:true});
				</script>
			';
		return '<div id="imageslist'.$key.'">'.$helper->generateForm($this->fields_form).$string.'</div>';
	}

	public function renderContent($setting)
	{
		$t = array();
		$setting = array_merge($t, $setting);
		//d($setting);
		$language_id = Context::getContext()->language->id;
		$contents = array();
		for ($i = 1; $i <= 5; $i++) {
			$contents[$i]['image'] = isset($setting['imagefile'.$i]) && $setting['imagefile'.$i] ? _PAGEBUILDER_IMAGE_URL_.$setting['imagefile'.$i] : '';
			$contents[$i]['title'] = isset($setting['title'.$i.'_'.$language_id]) && $setting['title'.$i.'_'.$language_id] ? $setting['title'.$i.'_'.$language_id] : '';
			$contents[$i]['description'] = isset($setting['description'.$i.'_'.$language_id]) && $setting['description'.$i.'_'.$language_id] ? $setting['description'.$i.'_'.$language_id] : '';
			$contents[$i]['button_link'] = isset($setting['button_link'.$i.'_'.$language_id]) && $setting['button_link'.$i.'_'.$language_id] ? $setting['button_link'.$i.'_'.$language_id] : '';
		}
		$setting['contents'] = $contents;
		$output = array('type' => 'contentslider', 'data' => $setting);
		return $output;
	}

}
